<?php $__env->startSection('content'); ?>
<div class="container">
    <h1>My Bookings</h1>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Equipment</th>
                <th>Quantity</th>
                <th>Booking Date</th>
                <th>Booking Time</th> 
                <th>Return Date</th>
                <th>Return Time</th> 
                <th>Location</th> 
                <th>Status</th>
                <th>Reason</th> 
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $bookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><?php echo e($booking->equipment->name); ?></td>
                    <td><?php echo e($booking->quantity); ?></td>
                    <td><?php echo e(\Carbon\Carbon::parse($booking->date_of_booking)->format('F j, Y')); ?></td>
                    <td><?php echo e($booking->booking_time ?? '-'); ?></td> 
                    <td><?php echo e(\Carbon\Carbon::parse($booking->date_of_return)->format('F j, Y')); ?></td>
                    <td><?php echo e($booking->return_time ?? '-'); ?></td> 
                    <td><?php echo e($booking->location ?? '-'); ?></td> 
                    <td><?php echo e($booking->status ?? 'Pending'); ?></td>
                    <td>
    <?php if($booking->status === 'Rejected'): ?>
        <?php echo e($booking->rejection_reason ?? 'No reason provided'); ?>

    <?php else: ?>
    <?php endif; ?>
</td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="8">No bookings yet.</td> 
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\James\Laravel\App\example\resources\views/bookings/index.blade.php ENDPATH**/ ?>